<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Flash Messages -->
<?php if($this->session->flashdata('message')): ?>
    <div class="container py-3">
        <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show" role="alert">
            <?php echo $this->session->flashdata('message'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<?php
// Manual WhatsApp number - Change this to your WhatsApp number
$whatsapp_number = '233593854493'; // Format: Country code + number (no + sign, spaces, or dashes)
?>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <h3 class="fw-bold mb-4">Send Us a Message</h3>
                    
                    <?php echo form_open('contact/submit'); ?>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="<?php echo set_value('name'); ?>" required>
                                <?php echo form_error('name', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" value="<?php echo set_value('email'); ?>" required>
                                <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Phone</label>
                                <input type="tel" class="form-control" name="phone" value="<?php echo set_value('phone'); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Subject <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="subject" value="<?php echo set_value('subject'); ?>" required>
                                <?php echo form_error('subject', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Message <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="message" rows="6" required><?php echo set_value('message'); ?></textarea>
                            <?php echo form_error('message', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane"></i> Send Message
                        </button>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Contact Information Card -->
            <div class="card shadow border-0 mb-4">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-3">Contact Information</h5>
                    
                    <?php if (!empty($site_settings['site_email'])): ?>
                        <div class="mb-3">
                            <i class="fas fa-envelope text-primary fa-lg me-2"></i>
                            <a href="mailto:<?php echo $site_settings['site_email']; ?>">
                                <?php echo $site_settings['site_email']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($site_settings['site_phone'])): ?>
                        <div class="mb-3">
                            <i class="fas fa-phone text-primary fa-lg me-2"></i>
                            <a href="tel:<?php echo $site_settings['site_phone']; ?>">
                                <?php echo $site_settings['site_phone']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($whatsapp_number)): ?>
                        <div class="mb-3">
                            <i class="fab fa-whatsapp text-success fa-lg me-2"></i>
                            <a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20would%20like%20to%20get%20in%20touch" target="_blank" class="text-success">
                                +<?php echo $whatsapp_number; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($site_settings['site_address'])): ?>
                        <div class="mb-3">
                            <i class="fas fa-map-marker-alt text-primary fa-lg me-2"></i>
                            <?php echo nl2br($site_settings['site_address']); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Quick Contact via WhatsApp Card -->
            <?php if (!empty($whatsapp_number)): ?>
            <div class="card shadow border-0 mb-4" style="background: linear-gradient(135deg, #25D366, #128C7E);">
                <div class="card-body p-4 text-white text-center">
                    <i class="fab fa-whatsapp fa-3x mb-3"></i>
                    <h5 class="fw-bold mb-3">Chat with us on WhatsApp</h5>
                    <p class="mb-3">Get instant responses to your queries</p>
                    <a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20would%20like%20to%20inquire%20about%20your%20services" 
                       target="_blank" 
                       class="btn btn-light btn-lg w-100">
                        <i class="fab fa-whatsapp me-2"></i> Start WhatsApp Chat
                    </a>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Office Hours Card -->
            <div class="card shadow border-0" style="background: linear-gradient(135deg, #f26124, #8105bf);">
                <div class="card-body p-4 text-white text-center">
                    <h5 class="fw-bold mb-3">Office Hours</h5>
                    <p class="mb-2"><strong>Monday - Friday</strong></p>
                    <p class="mb-2">9:00 AM - 5:00 PM</p>
                    <hr style="border-color: rgba(255,255,255,0.3);">
                    <p class="mb-0">We typically respond within 24-48 hours</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Floating WhatsApp Button -->
<?php if (!empty($whatsapp_number)): ?>
<a href="https://wa.me/<?php echo $whatsapp_number; ?>?text=Hello,%20I%20need%20assistance" 
   target="_blank" 
   class="whatsapp-float" 
   title="Chat on WhatsApp">
    <i class="fab fa-whatsapp"></i>
</a>

<style>
.whatsapp-float {
    position: fixed;
    width: 60px;
    height: 60px;
    bottom: 40px;
    right: 40px;
    background-color: #25D366;
    color: #FFF;
    border-radius: 50px;
    text-align: center;
    font-size: 30px;
    box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.3);
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    text-decoration: none;
}

.whatsapp-float:hover {
    background-color: #128C7E;
    transform: scale(1.1);
    box-shadow: 2px 2px 15px rgba(0, 0, 0, 0.4);
    color: #FFF;
}

.whatsapp-float i {
    margin-top: 3px;
}

@media screen and (max-width: 768px) {
    .whatsapp-float {
        width: 50px;
        height: 50px;
        bottom: 20px;
        right: 20px;
        font-size: 25px;
    }
}
</style>
<?php endif; ?>